import { View, Text, TouchableOpacity } from "react-native";
import React from "react";
import styles from "./QueryStyle";
import ChatIcon from "../../../../../assets/svgs/chat-icon.svg";
import PhoneIcon from "../../../../../assets/svgs/phone.svg";
import EmailIcon from "../../../../../assets/svgs/email.svg";
import LocationIcon from "../../../../../assets/svgs/location.svg";
import useCustomToast from "../../../../../hooks/useCustomToast";
import useLangTranslation from "../../../../../hooks/useLangTranslation";
import dpr from "../../../../../screens/Utilities/CustomStyleAttribute/dpr";
import CustomSpinner from "../../../../../screens/Utilities/CustomSpinner/CustomSpinner";
import CustomSVG from "../../../CustomSVG/CustomSVG";

const Query = ({vendorProfileInfo, loading, vendor}) => {
	const { trans } = useLangTranslation();
	const showToast = useCustomToast();
	const { shop, reviewCount, positiveRating, shipment_on_time, seller_cancellation  } = vendorProfileInfo || {};

	const handleChatNow = () => {
		showToast({
			text1: trans("Chat Now Feature Coming Soon..."),
			type: "common",
			position: "bottom",
			props: { variant: "success" },
		});
	}

	return (
		<View style={styles.container}>
			<View style={styles.chatNow}>
				<View style={styles.chatNowDesc}>
					<Text style={styles.chatNowTitle}>{trans("Have any query")}?</Text>
					<Text style={styles.chatNowSubtitle}>{trans("Send us a message")}</Text>
				</View>
				<TouchableOpacity onPress={handleChatNow} style={styles.chatNowButton}>
					<Text style={styles.chatNowButtonText}>{trans("Chat Now")}</Text>
					<CustomSVG svgIcon={ChatIcon} />
				</TouchableOpacity>
			</View>
			<View>
				<Text style={styles.description}>
					{vendor?.description}
				</Text>
				{loading ? (
					<CustomSpinner
						filePath={require("../../../../../assets/lottie/loader2.json")}
						size={{
							width: dpr(60),
							height: dpr(55),
						}}
					/>
				) : (
					<View style={styles.support}>
						<View style={styles.supportItem}>
							<CustomSVG svgIcon={PhoneIcon} />
							<Text style={styles.supportText}>
								{shop?.phone}
							</Text>
						</View>
						<View style={styles.supportItem}>
							<CustomSVG svgIcon={EmailIcon} />
							<Text style={styles.supportText}>{shop?.email}</Text>
						</View>
						<View style={styles.supportItem}>
							<CustomSVG svgIcon={LocationIcon} />
							<Text style={styles.supportText}>
								{shop?.address}, {shop?.city}, {shop?.country}
							</Text>
						</View>
					</View>
				)}
				<View style={styles.profileCard}>
					<InfoCard idx={0} title={trans("Positive Seller Ratings")} count={positiveRating || 0}/>
					<InfoCard idx={1} title={trans("Shipment on Time")} count={shipment_on_time || 0} />
					<InfoCard idx={1} title={trans("Seller’s Cancellation")} count={seller_cancellation || 0}/>
					<InfoCard idx={1} title={trans("Seller Reviews")} count={reviewCount || 0}/>
				</View>
			</View>
		</View>
	);
};

export default Query;

const InfoCard = ({idx, title, count}) => {
	return (
		<View
			style={[
				styles.profileCardItem,
				styles.profileCardItemBg(idx)
			]}
		>
			<Text
				style={[
					styles.profileCardItemText,
					styles.profileCardItemTextColor(idx)
				]}
			>
				{title}
			</Text>
			<Text
				style={[
					styles.profileCardItemCount,
					styles.profileCardItemCountColor(idx)
				]}
			>
				{count}
				<Text
					style={[
						styles.percentage,
						styles.profileCardItemCountColor(idx)
					]}
				>
					%
				</Text>
			</Text>
		</View>
	)
}
